<?php

use App\Models\Client;
use App\Models\Deal;
use App\Models\Lead;
use App\Models\Property;
use App\Models\User;

it('can create a user with rems fields', function () {
    $user = User::factory()->create([
        'role' => 'agent',
        'commission_rate' => 3.50,
        'is_active' => true,
        'joined_at' => '2024-01-15',
    ]);

    expect($user->role)->toBe('agent')
        ->and($user->commission_rate)->toBe('3.50')
        ->and($user->is_active)->toBeTrue()
        ->and($user->joined_at->format('Y-m-d'))->toBe('2024-01-15');
});

it('has properties relationship', function () {
    $agent = User::factory()->create(['role' => 'agent']);
    Property::factory()->count(3)->create(['agent_id' => $agent->id]);

    expect($agent->properties)->toHaveCount(3);
});

it('has clients relationship', function () {
    $agent = User::factory()->create(['role' => 'agent']);
    Client::factory()->count(2)->create(['agent_id' => $agent->id]);

    expect($agent->clients)->toHaveCount(2);
});

it('has leads relationship', function () {
    $agent = User::factory()->create(['role' => 'agent']);
    Lead::factory()->count(4)->create(['agent_id' => $agent->id]);

    expect($agent->leads)->toHaveCount(4);
});

it('has deals relationship', function () {
    $agent = User::factory()->create(['role' => 'agent']);
    Deal::factory()->count(2)->create(['agent_id' => $agent->id]);

    expect($agent->deals)->toHaveCount(2);
});
