<?php

use App\Models\Document;
use App\Models\Lease;
use App\Models\LeasePayment;

it('belongs to property and tenant', function () {
    $lease = Lease::factory()->create();

    expect($lease->property)->not->toBeNull()
        ->and($lease->tenant)->not->toBeNull();
});

it('has payments', function () {
    $lease = Lease::factory()->create();
    LeasePayment::factory()->count(12)->create(['lease_id' => $lease->id]);

    expect($lease->payments)->toHaveCount(12);
});

it('tracks paid status on payments', function () {
    $lease = Lease::factory()->create();
    $payment = LeasePayment::factory()->paid()->create([
        'lease_id' => $lease->id,
        'due_date' => '2025-01-01',
    ]);

    expect($payment->is_paid)->toBeTrue()
        ->and($payment->paid_at)->not->toBeNull();
});

it('has polymorphic documents', function () {
    $lease = Lease::factory()->create();
    Document::factory()->create([
        'documentable_type' => Lease::class,
        'documentable_id' => $lease->id,
    ]);

    expect($lease->documents)->toHaveCount(1);
});

it('casts dates correctly', function () {
    $lease = Lease::factory()->create([
        'start_date' => '2025-01-01',
        'end_date' => '2025-12-31',
    ]);

    $lease->refresh();

    expect($lease->start_date->format('Y-m-d'))->toBe('2025-01-01')
        ->and($lease->end_date->format('Y-m-d'))->toBe('2025-12-31')
        ->and($lease->is_renewable)->toBeBool();
});
