<?php

use App\Models\Lead;

it('belongs to client, property, and agent', function () {
    $lead = Lead::factory()->create();

    expect($lead->client)->not->toBeNull()
        ->and($lead->property)->not->toBeNull()
        ->and($lead->agent)->not->toBeNull();
});

it('allows nullable client and property', function () {
    $lead = Lead::factory()->create([
        'client_id' => null,
        'property_id' => null,
    ]);

    expect($lead->client)->toBeNull()
        ->and($lead->property)->toBeNull();
});

it('casts budget fields correctly', function () {
    $lead = Lead::factory()->create([
        'budget_min' => 500000.00,
        'budget_max' => 1500000.00,
    ]);

    $lead->refresh();

    expect($lead->budget_min)->toBe('500000.00')
        ->and($lead->budget_max)->toBe('1500000.00');
});

it('casts next_follow_up_at as date', function () {
    $lead = Lead::factory()->create([
        'next_follow_up_at' => '2025-06-15',
    ]);

    $lead->refresh();

    expect($lead->next_follow_up_at->format('Y-m-d'))->toBe('2025-06-15');
});
