<?php

use App\Models\Deal;
use App\Models\DealStageHistory;
use App\Models\Document;
use App\Models\User;

it('belongs to property, client, and agent', function () {
    $deal = Deal::factory()->create();

    expect($deal->property)->not->toBeNull()
        ->and($deal->client)->not->toBeNull()
        ->and($deal->agent)->not->toBeNull();
});

it('has stage history', function () {
    $deal = Deal::factory()->create(['stage' => 'offer']);

    DealStageHistory::factory()->create(['deal_id' => $deal->id, 'from_stage' => null, 'to_stage' => 'inquiry']);
    DealStageHistory::factory()->create(['deal_id' => $deal->id, 'from_stage' => 'inquiry', 'to_stage' => 'viewing']);
    DealStageHistory::factory()->create(['deal_id' => $deal->id, 'from_stage' => 'viewing', 'to_stage' => 'offer']);

    expect($deal->stageHistory)->toHaveCount(3);
});

it('stage history records the changer', function () {
    $user = User::factory()->create();
    $history = DealStageHistory::factory()->create(['changed_by' => $user->id]);

    expect($history->changer->id)->toBe($user->id);
});

it('has polymorphic documents', function () {
    $deal = Deal::factory()->create();
    Document::factory()->create([
        'documentable_type' => Deal::class,
        'documentable_id' => $deal->id,
    ]);

    expect($deal->documents)->toHaveCount(1);
});

it('casts deal_value and commission_amount correctly', function () {
    $deal = Deal::factory()->create([
        'deal_value' => 1500000.50,
        'commission_amount' => 45000.75,
    ]);

    $deal->refresh();

    expect($deal->deal_value)->toBe('1500000.50')
        ->and($deal->commission_amount)->toBe('45000.75');
});
