<?php

use App\Models\Account;
use App\Models\Client;
use App\Models\ClientInteraction;
use App\Models\Deal;
use App\Models\Document;
use App\Models\Lead;
use App\Models\Lease;
use App\Models\User;

it('belongs to an agent', function () {
    $agent = User::factory()->create(['role' => 'agent']);
    $client = Client::factory()->create(['agent_id' => $agent->id]);

    expect($client->agent->id)->toBe($agent->id);
});

it('has interactions', function () {
    $client = Client::factory()->create();
    ClientInteraction::factory()->count(3)->create(['client_id' => $client->id]);

    expect($client->interactions)->toHaveCount(3);
});

it('has leads', function () {
    $client = Client::factory()->create();
    Lead::factory()->count(2)->create(['client_id' => $client->id]);

    expect($client->leads)->toHaveCount(2);
});

it('has deals', function () {
    $client = Client::factory()->create();
    Deal::factory()->count(2)->create(['client_id' => $client->id]);

    expect($client->deals)->toHaveCount(2);
});

it('has leases', function () {
    $client = Client::factory()->create();
    Lease::factory()->create(['client_id' => $client->id]);

    expect($client->leases)->toHaveCount(1);
});

it('has accounts', function () {
    $client = Client::factory()->create();
    Account::factory()->create(['client_id' => $client->id]);

    expect($client->accounts)->toHaveCount(1);
});

it('has polymorphic documents', function () {
    $client = Client::factory()->create();
    Document::factory()->create([
        'documentable_type' => Client::class,
        'documentable_id' => $client->id,
    ]);

    expect($client->documents)->toHaveCount(1);
});
