<?php

use App\Models\Account;
use App\Models\AccountTransaction;
use App\Models\Client;

it('has transactions', function () {
    $account = Account::factory()->create();
    AccountTransaction::factory()->count(5)->create(['account_id' => $account->id]);

    expect($account->transactions)->toHaveCount(5);
});

it('can belong to a client', function () {
    $client = Client::factory()->create();
    $account = Account::factory()->create(['client_id' => $client->id]);

    expect($account->client->id)->toBe($client->id);
});

it('tracks system-created flag', function () {
    $account = Account::factory()->systemCreated()->create();

    expect($account->is_system_created)->toBeTrue();
});

it('casts balance correctly', function () {
    $account = Account::factory()->create(['balance' => 150000.75]);
    $account->refresh();

    expect($account->balance)->toBe('150000.75')
        ->and($account->is_active)->toBeBool();
});

it('transaction belongs to an account', function () {
    $account = Account::factory()->create();
    $transaction = AccountTransaction::factory()->create([
        'account_id' => $account->id,
        'type' => 'credit',
        'amount' => 5000,
    ]);

    expect($transaction->account->id)->toBe($account->id)
        ->and($transaction->type)->toBe('credit');
});
