<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->after('email');
            $table->string('role')->default('agent')->after('phone');
            $table->string('profile_photo_path')->nullable()->after('role');
            $table->decimal('commission_rate', 5, 2)->default(0)->after('profile_photo_path');
            $table->boolean('is_active')->default(true)->after('commission_rate');
            $table->date('joined_at')->nullable()->after('is_active');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'phone',
                'role',
                'profile_photo_path',
                'commission_rate',
                'is_active',
                'joined_at',
            ]);
        });
    }
};
