<?php

namespace Database\Factories;

use App\Models\Property;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Property>
 */
class PropertyFactory extends Factory
{
    public function definition(): array
    {
        return [
            'title' => fake()->sentence(4),
            'description' => fake()->paragraphs(2, true),
            'property_type' => fake()->randomElement(['residential', 'commercial', 'rental']),
            'status' => fake()->randomElement(['available', 'sold', 'rented', 'reserved']),
            'asking_price' => fake()->randomFloat(2, 100000, 5000000),
            'city' => fake()->city(),
            'area' => fake()->streetName(),
            'address' => fake()->address(),
            'latitude' => fake()->latitude(24.4, 25.4),
            'longitude' => fake()->longitude(54.3, 55.6),
            'bedrooms' => fake()->numberBetween(1, 7),
            'bathrooms' => fake()->numberBetween(1, 5),
            'area_sqft' => fake()->numberBetween(500, 10000),
            'year_built' => fake()->numberBetween(1990, 2025),
            'agent_id' => User::factory(),
        ];
    }

    public function available(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'available',
        ]);
    }

    public function sold(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'sold',
        ]);
    }

    public function rented(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'rented',
        ]);
    }

    public function residential(): static
    {
        return $this->state(fn (array $attributes) => [
            'property_type' => 'residential',
        ]);
    }

    public function commercial(): static
    {
        return $this->state(fn (array $attributes) => [
            'property_type' => 'commercial',
        ]);
    }

    public function rental(): static
    {
        return $this->state(fn (array $attributes) => [
            'property_type' => 'rental',
        ]);
    }
}
