<?php

namespace Database\Factories;

use App\Models\Lease;
use App\Models\LeasePayment;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<LeasePayment>
 */
class LeasePaymentFactory extends Factory
{
    public function definition(): array
    {
        return [
            'lease_id' => Lease::factory(),
            'due_date' => fake()->date(),
            'amount_due' => fake()->randomFloat(2, 2000, 25000),
            'is_paid' => false,
            'paid_at' => null,
        ];
    }

    public function paid(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_paid' => true,
            'paid_at' => fake()->dateTimeBetween($attributes['due_date'] ?? '-1 month', 'now'),
        ]);
    }
}
