<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Lease;
use App\Models\Property;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Lease>
 */
class LeaseFactory extends Factory
{
    public function definition(): array
    {
        $startDate = fake()->dateTimeBetween('-1 year', 'now');

        return [
            'property_id' => Property::factory(),
            'client_id' => Client::factory(),
            'start_date' => $startDate,
            'end_date' => (clone $startDate)->modify('+12 months'),
            'monthly_rent' => fake()->randomFloat(2, 2000, 25000),
            'security_deposit' => fake()->randomFloat(2, 2000, 25000),
            'status' => 'active',
            'is_renewable' => fake()->boolean(40),
            'termination_reason' => null,
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'active',
        ]);
    }

    public function expired(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'expired',
        ]);
    }

    public function terminated(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'terminated',
            'termination_reason' => fake()->sentence(),
        ]);
    }
}
