<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Lead;
use App\Models\Property;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Lead>
 */
class LeadFactory extends Factory
{
    public function definition(): array
    {
        $budgetMin = fake()->randomFloat(2, 50000, 2000000);

        return [
            'client_id' => Client::factory(),
            'property_id' => Property::factory(),
            'source' => fake()->randomElement(['website', 'referral', 'walk_in', 'social_media', 'portal', 'other']),
            'status' => fake()->randomElement(['new', 'contacted', 'qualified', 'lost', 'converted']),
            'budget_min' => $budgetMin,
            'budget_max' => $budgetMin + fake()->randomFloat(2, 100000, 1000000),
            'next_follow_up_at' => fake()->optional(0.7)->dateTimeBetween('now', '+30 days'),
            'agent_id' => User::factory(),
            'notes' => fake()->optional(0.6)->paragraph(),
        ];
    }
}
