<?php

namespace Database\Factories;

use App\Models\Document;
use App\Models\Property;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Document>
 */
class DocumentFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->sentence(3),
            'type' => fake()->randomElement(['sale_agreement', 'title_deed', 'noc', 'lease', 'client_id_doc', 'valuation_report', 'other']),
            'file_path' => 'documents/'.fake()->uuid().'.pdf',
            'documentable_type' => Property::class,
            'documentable_id' => Property::factory(),
            'uploaded_by' => User::factory(),
        ];
    }
}
