<?php

namespace Database\Factories;

use App\Models\Deal;
use App\Models\DealStageHistory;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<DealStageHistory>
 */
class DealStageHistoryFactory extends Factory
{
    public function definition(): array
    {
        return [
            'deal_id' => Deal::factory(),
            'from_stage' => null,
            'to_stage' => 'inquiry',
            'changed_by' => User::factory(),
            'note' => fake()->optional(0.5)->sentence(),
        ];
    }
}
