<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\Deal;
use App\Models\Property;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Deal>
 */
class DealFactory extends Factory
{
    public function definition(): array
    {
        $dealValue = fake()->randomFloat(2, 200000, 5000000);

        return [
            'title' => fake()->sentence(3),
            'property_id' => Property::factory(),
            'client_id' => Client::factory(),
            'agent_id' => User::factory(),
            'stage' => fake()->randomElement(['inquiry', 'viewing', 'offer', 'negotiation', 'agreement', 'closing', 'closed']),
            'deal_value' => $dealValue,
            'commission_amount' => round($dealValue * fake()->randomFloat(4, 0.01, 0.05), 2),
            'expected_closing_date' => fake()->dateTimeBetween('now', '+6 months'),
            'notes' => fake()->optional(0.5)->paragraph(),
        ];
    }
}
