<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\ClientInteraction;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<ClientInteraction>
 */
class ClientInteractionFactory extends Factory
{
    public function definition(): array
    {
        return [
            'client_id' => Client::factory(),
            'type' => fake()->randomElement(['call', 'meeting', 'email', 'visit', 'note']),
            'note' => fake()->sentence(),
            'recorded_by' => User::factory(),
        ];
    }
}
