<?php

namespace Database\Factories;

use App\Models\Client;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Client>
 */
class ClientFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->name(),
            'national_id' => fake()->numerify('###-####-#######-#'),
            'email' => fake()->unique()->safeEmail(),
            'phone' => fake()->phoneNumber(),
            'address' => fake()->address(),
            'client_type' => fake()->randomElement(['buyer', 'seller', 'tenant', 'landlord']),
            'agent_id' => User::factory(),
            'notes' => fake()->optional(0.5)->paragraph(),
        ];
    }

    public function buyer(): static
    {
        return $this->state(fn (array $attributes) => [
            'client_type' => 'buyer',
        ]);
    }

    public function seller(): static
    {
        return $this->state(fn (array $attributes) => [
            'client_type' => 'seller',
        ]);
    }

    public function tenant(): static
    {
        return $this->state(fn (array $attributes) => [
            'client_type' => 'tenant',
        ]);
    }

    public function landlord(): static
    {
        return $this->state(fn (array $attributes) => [
            'client_type' => 'landlord',
        ]);
    }
}
