<?php

namespace Database\Factories;

use App\Models\Amenity;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Amenity>
 */
class AmenityFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->randomElement([
                'Parking',
                'Swimming Pool',
                'Gym',
                'Garden',
                'Security',
                'Elevator',
                'Balcony',
                'Central AC',
                'Maid Room',
                'Storage Room',
                'Concierge',
                'Children Play Area',
                'BBQ Area',
                'Sauna',
                'Jacuzzi',
            ]),
        ];
    }
}
