<?php

namespace Database\Factories;

use App\Models\Account;
use App\Models\AccountTransaction;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<AccountTransaction>
 */
class AccountTransactionFactory extends Factory
{
    public function definition(): array
    {
        return [
            'account_id' => Account::factory(),
            'type' => fake()->randomElement(['debit', 'credit']),
            'amount' => fake()->randomFloat(2, 100, 50000),
            'description' => fake()->sentence(),
            'transaction_date' => fake()->dateTimeBetween('-1 year', 'now'),
            'transactionable_type' => null,
            'transactionable_id' => null,
        ];
    }
}
