<?php

namespace Database\Factories;

use App\Models\Account;
use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Account>
 */
class AccountFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => fake()->words(3, true),
            'code' => fake()->unique()->numerify('ACC-####'),
            'account_type' => fake()->randomElement(['asset', 'liability', 'income', 'expense']),
            'account_sub_type' => fake()->randomElement(['receivable', 'rental_income', 'commission', 'security_deposit', 'maintenance']),
            'balance' => fake()->randomFloat(2, 0, 500000),
            'is_system_created' => false,
            'is_active' => true,
            'client_id' => null,
        ];
    }

    public function forClient(Client $client): static
    {
        return $this->state(fn (array $attributes) => [
            'client_id' => $client->id,
        ]);
    }

    public function systemCreated(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_system_created' => true,
        ]);
    }
}
